<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
package ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import ${pub.getPKGCodeName()}.util.domain.EntityBase;
import ${pub.getPKGCodeName()}.util.annotation.DEField;
import ${pub.getPKGCodeName()}.util.enums.DEPredefinedFieldType;
import ${pub.getPKGCodeName()}.util.enums.DEFieldDefaultValueType;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;

<#comment>SQL存储-Mybatis</#comment>
<#if de.getStorageMode()==1>

import com.baomidou.mybatisplus.annotation.*;
import ${pub.getPKGCodeName()}.util.domain.EntityMP;


/**
 * 实体[${item.getLogicName()}]
 */
<#--@Builder-->
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "${item.getTableName()}",resultMap = "${item.codeName}ResultMap")
public class ${item.getCodeName()} extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    <#if de.getPSDEFields()??>
        <#comment>输出实体属性</#comment>
        <#list de.getPSDEFields() as defield>
        <#assign defDataType = (defield.getDataType())!"">
        <#if defDataType!='ONE2MANYDATA'>
        <#assign columnname = defield.getName()?lower_case>
        <#assign prvateCodeName = srfcaseformat(defield.getCodeName(),'l_u2lC') >
        <#assign publicCodeName = prvateCodeName?cap_first >
        <#assign jsonfield = defield.getCodeName()?lower_case >
        <#assign tablefieldano = "value = \""+columnname+"\"" >
        <#assign defieldano = "" >
        <#if prvateCodeName?lower_case != columnname>
            <#assign defieldano = "name = \""+columnname+"\"">
        </#if>
        <#if defield.getDefaultValue()?? && defield.getDefaultValue()!=''>
            <#assign defieldano = "defaultValue = \""+defield.getDefaultValue()+"\"">
        </#if>
        <#if defield.getDefaultValueType()?? && defield.getDefaultValueType()!=''>
            <#if defieldano?? && defieldano!=''>
                <#assign defieldano = defieldano+" , ">
            </#if>
            <#assign defieldano = defieldano+"defaultValueType = DEFieldDefaultValueType."+defield.getDefaultValueType()?upper_case>
        </#if>
        <#if defield.isKeyDEField()==true>
            <#if defieldano?? && defieldano!=''>
                <#assign defieldano = defieldano+" , ">
            </#if>
            <#assign defieldano = defieldano+"isKeyField=true">
        <#elseif defield.getPredefinedType()?? && defield.getPredefinedType()!=''>
            <#if defieldano?? && defieldano!=''>
                <#assign defieldano = defieldano+" , ">
            </#if>
            <#assign defieldano = defieldano+"preType = DEPredefinedFieldType."+defield.getPredefinedType()?upper_case>
            <#if defield.getPredefinedType()?lower_case =='createdate'||defield.getPredefinedType()?lower_case =='createman'>
                <#assign tablefieldano = tablefieldano+" , fill = FieldFill.INSERT">
            <#elseif defield.getPredefinedType()?lower_case =='logicvalid'>
                <#if de.getLogicValidPSDEField()?? && de.isLogicValid()==true>
                    <#assign defieldano = defieldano+", logicval = \""+((item.getValidLogicValue())!'1')+"\" , logicdelval=\""+((item.getInvalidLogicValue())!'0')+"\"">
                </#if>
            </#if>
        </#if>
    /**
     * ${defield.getLogicName()}
     */
            <#comment>属性默认值</#comment>
            <#if defieldano?? && defieldano!='' && defield.isPhisicalDEField()==true>
    @DEField(${defieldano})
            </#if>
            <#comment>主键</#comment>
            <#if defield.isKeyDEField()==true>
    @TableId(value= "${columnname}",type=IdType.UUID)
            <#elseif defield.isPhisicalDEField()==false>
    @TableField(exist = false)
            <#elseif  defield.getPredefinedType?? && defield.getPredefinedType()?? && defield.getPredefinedType()?lower_case =='logicvalid'>
                        <#comment>逻辑有效默认值-用于mybatis-plus删除时update逻辑有效值</#comment>
                        <#if de.getLogicValidPSDEField()?? && de.isLogicValid()==true>
                            <#if (((item.getValidLogicValue())!'')!='')  && (((item.getInvalidLogicValue())!'')!='')>
    @TableLogic(value= "${item.getValidLogicValue()}",delval="${item.getInvalidLogicValue()}")
                            <#else>
    @TableLogic
                            </#if>
                        </#if>
    @TableField(${tablefieldano})
            <#else>
    @TableField(${tablefieldano})
            </#if>
            <#if defDataType == "DATETIME" || (defDataType=='PICKUPDATA' && srfdatatype(defield.getStdDataType())== "DATETIME" && defield.getValueFormat()=="%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "${jsonfield}" , format="yyyy-MM-dd HH:mm:ss")
            <#elseif defDataType == "DATE" || (defDataType=='PICKUPDATA' && srfdatatype(defield.getStdDataType())== "DATETIME" && defield.getValueFormat()=="%1$tY-%1$tm-%1$td")>
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "${jsonfield}" , format="yyyy-MM-dd")
            <#elseif defDataType == "TIME" || (defDataType=='PICKUPDATA' && srfdatatype(defield.getStdDataType())== "DATETIME" && defield.getValueFormat()=="%1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="HH:mm", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "${jsonfield}" , format="HH:mm")
            <#else>
    @JSONField(name = "${jsonfield}")
            </#if>
    @JsonProperty("${jsonfield}")
    private ${srfjavatype(defield.getStdDataType())} ${prvateCodeName};
        </#if>
        </#list>

        <#comment>创建1：N关系实体-输出主实体</#comment>
        <#if item.getMinorPSDERs?? && item.getMinorPSDERs()??>
            <#list item.getMinorPSDERs() as MinorPSDER>
                <#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
                    <#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()?? && MinorPSDER.getCodeName?? && MinorPSDER.getCodeName()??>
                        <#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
                        <#if MajorEntity.getCodeName?? && MinorPSDER.getCodeName()?? >
    /**
     * ${MinorPSDER.getLogicName()}
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private ${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().getCodeName()?lower_case}.domain.${MajorEntity.getCodeName()} ${srfcaseformat(MinorPSDER.getCodeName(),'l_u2lC')};

                        </#if>
                    </#if>
                </#if>
            </#list>
        </#if>

        <#comment>输出关系数据（子实体）</#comment>
        <#if de.getMajorPSDERs()??>
            <#list de.getMajorPSDERs() as der>
                <#if der.getDERType() =='DER1N' >
                    <#assign listcode=(der.getMinorCodeName()!der.getMinorPSDataEntity().getCodeName())>
                    <#if listcode?? && listcode==''><#assign listcode=der.getMinorPSDataEntity().getCodeName()></#if>
                    <#assign columnname=srfcaseformat(listcode,'l_u2lC')>
                    <#assign subDTOs = srfpluralize(listcode)?lower_case >
                    <#assign nested=der.isNestedRS()>
                    <#if nested == false && der.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                        <#list der.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                            <#if api.isNested()>
                                <#assign nested=true>
                            </#if>
                        </#list>
                    </#if>
                    <#if nested>
    /**
     * ${der.getMinorPSDataEntity().getLogicName()}
     */
    <#if der.getMinorPSDataEntity().getStorageMode()==0>
    @JSONField(name = "${subDTOs}")
    @JsonProperty("${subDTOs}")
    <#if der.getPSOne2ManyDataDEField()?? && der.getPSOne2ManyDataDEField().isPhisicalDEField()==true>
    <#assign columnname=der.getPSOne2ManyDataDEField().getName()?lower_case>
    @TableField(value = "${columnname}" , typeHandler = ${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.domain.handlers.${der.getMinorPSDataEntity().getCodeName()}TypeHandler.class)
    <#else >
    @TableField(exist = false)
    </#if>
    <#else>
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    </#if>
    private List<${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.domain.${der.getMinorPSDataEntity().getCodeName()}> ${srfcaseformat(listcode,'l_u2lC')};

    <#if der.getMinorPSDataEntity().getStorageMode()==0 && der.getPSOne2ManyDataDEField()?? && der.getPSOne2ManyDataDEField().isPhisicalDEField()==true>
    /**
     * 设置 [${der.getMinorPSDataEntity().getLogicName()}]
     */
    public void set${srfcaseformat(listcode,'l_u2lC')?cap_first}(List<${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.domain.${der.getMinorPSDataEntity().getCodeName()}> ${srfcaseformat(listcode,'l_u2lC')}){
        this.${srfcaseformat(listcode,'l_u2lC')} = ${srfcaseformat(listcode,'l_u2lC')} ;
        this.modify("${columnname}",(${srfcaseformat(listcode,'l_u2lC')}!=null)?${srfcaseformat(listcode,'l_u2lC')}:(new ArrayList()));
    }
    </#if>
                    </#if>
                </#if>
            </#list>
        </#if>

        <#comment>输出set方法用于设置null值</#comment>
        <#list de.getPSDEFields() as defield>
            <#assign defDataType = (defield.getDataType())!"">
            <#assign columnname = defield.getName()?lower_case>
            <#assign prvateCodeName = srfcaseformat(defield.getCodeName(),'l_u2lC') >
            <#assign publicCodeName = prvateCodeName?cap_first >
            <#assign jsonfield = defield.getCodeName()?lower_case >
            <#if defield.isPhisicalDEField()==true && defield.isKeyDEField()==false && defDataType!='ONE2MANYDATA'>
            <#if defield.getPredefinedType()?? && defield.getPredefinedType()!=''>
                <#else >
    /**
     * 设置 [${defield.getLogicName()}]
     */
    public void set${publicCodeName}(${srfjavatype(defield.getStdDataType())} ${prvateCodeName}){
        this.${prvateCodeName} = ${prvateCodeName} ;
        this.modify("${columnname}",${prvateCodeName});
    }
                </#if>
            </#if>
        </#list>
    </#if>

    <#comment>联合主键</#comment>
    <#if item.getUnionKeyValuePSDEFields()??>
        <#assign keyField = item.getKeyPSDEField()>
        <#assign privateCodeName = srfcaseformat(keyField.getCodeName(),'l_u2lC') >
        <#assign publicCodeName = privateCodeName?cap_first >
    /**
     * 获取 [${keyField.getLogicName()}]
     */
    public ${srfjavatype(keyField.getStdDataType())} get${publicCodeName}(){
        if(ObjectUtils.isEmpty(${privateCodeName})){
            ${privateCodeName}=(${srfjavatype(keyField.stdDataType)})getDefaultKey(true);
        }
        return ${privateCodeName};
    }

    @Override
    public Serializable getDefaultKey(boolean gen) {
        ${checkUnionKey(item.getUnionKeyValuePSDEFields())}
            return DigestUtils.md5DigestAsHex(${getUnionKey(item.getUnionKeyValuePSDEFields())}.getBytes());
        return null;
    }
    </#if>
}

<#comment>NoSQL存储-MongoDB</#comment>
<#elseif de.getStorageMode()==2>

import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.mapping.FieldType;
import ${pub.getPKGCodeName()}.util.domain.EntityMongo;

/**
 * 大数据 [${item.getLogicName()}] 对象
 */
@Data
@Document(collection = "${item.getCodeName()?lower_case}")
public class ${item.getCodeName()} extends EntityMongo implements Serializable {

    <#if de.getPSDEFields()??>
        <#comment>输出实体属性</#comment>
        <#list de.getPSDEFields() as defield>
        <#assign defDataType = (defield.getDataType())!"">
        <#if defDataType!='ONE2MANYDATA'>
        <#assign columnname = defield.getName()?lower_case>
        <#assign prvateCodeName = srfcaseformat(defield.getCodeName(),'l_u2lC') >
        <#assign publicCodeName = prvateCodeName?cap_first >
        <#assign jsonfield = defield.getCodeName()?lower_case >
        <#assign defieldano = "" >
        <#if prvateCodeName?lower_case != columnname>
            <#assign defieldano = "name = \""+columnname+"\"">
        </#if>
        <#if defield.getDefaultValue()?? && defield.getDefaultValue()!=''>
            <#assign defieldano = "defaultValue = \""+defield.getDefaultValue()+"\"">
        </#if>
        <#if defield.getDefaultValueType()?? && defield.getDefaultValueType()!=''>
            <#if defieldano?? && defieldano!=''>
                <#assign defieldano = defieldano+" , ">
            </#if>
            <#assign defieldano = defieldano+"defaultValueType = DEFieldDefaultValueType."+defield.getDefaultValueType()?upper_case>
        </#if>
        <#if defield.isKeyDEField()==true>
            <#if defieldano?? && defieldano!=''>
                <#assign defieldano = defieldano+" , ">
            </#if>
            <#assign defieldano = defieldano+"isKeyField=true">
        <#elseif defield.getPredefinedType()?? && defield.getPredefinedType()!=''>
            <#if defieldano?? && defieldano!=''>
                <#assign defieldano = defieldano+" , ">
            </#if>
            <#assign defieldano = defieldano+"preType = DEPredefinedFieldType."+defield.getPredefinedType()?upper_case>
            <#if defield.getPredefinedType()?lower_case =='logicvalid'>
                <#if de.getLogicValidPSDEField()?? && de.isLogicValid()==true>
                    <#assign defieldano = defieldano+", logicval = \""+((item.getValidLogicValue())!'1')+"\" , logicdelval=\""+((item.getInvalidLogicValue())!'0')+"\"">
                </#if>
            </#if>
        </#if>
    /**
     * ${defield.getLogicName()}
     */
     <#if defield.isKeyDEField()==true>
    @Id()
     </#if>
            <#comment>属性默认值</#comment>
            <#if defieldano?? && defieldano!='' && defield.isPhisicalDEField()==true>
    @DEField(${defieldano})
            </#if>
            <#assign defDataType = (defield.getDataType())!"">
            <#if defDataType == "DATETIME" || (defDataType=='PICKUPDATA' && srfdatatype(defield.getStdDataType())== "DATETIME" && defield.getValueFormat()=="%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "${jsonfield}" , format="yyyy-MM-dd HH:mm:ss")
            <#elseif defDataType == "DATE" || (defDataType=='PICKUPDATA' && srfdatatype(defield.getStdDataType())== "DATETIME" && defield.getValueFormat()=="%1$tY-%1$tm-%1$td")>
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "${jsonfield}" , format="yyyy-MM-dd")
            <#elseif defDataType == "TIME" || (defDataType=='PICKUPDATA' && srfdatatype(defield.getStdDataType())== "DATETIME" && defield.getValueFormat()=="%1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="HH:mm", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "${jsonfield}" , format="HH:mm")
            <#else>
    @JSONField(name = "${jsonfield}")
            </#if>
    @JsonProperty("${jsonfield}")
    <#if defield.isKeyDEField()==false>
    @Field(name = "${columnname}")
    </#if>
    private ${srfjavatype(defield.getStdDataType())} ${prvateCodeName};

        </#if>
        </#list>

        <#comment>创建1：N关系实体-输出主实体</#comment>
        <#if item.getMinorPSDERs?? && item.getMinorPSDERs()??>
            <#list item.getMinorPSDERs() as MinorPSDER>
                <#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
                    <#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()?? && MinorPSDER.getCodeName?? && MinorPSDER.getCodeName()??>
                        <#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
                        <#if MajorEntity.getCodeName?? && MinorPSDER.getCodeName()?? >
    /**
     * ${MinorPSDER.getLogicName()}
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    private ${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().getCodeName()?lower_case}.domain.${MajorEntity.getCodeName()} ${srfcaseformat(MinorPSDER.getCodeName(),'l_u2lC')};

                        </#if>
                    </#if>
                </#if>
            </#list>
        </#if>

        <#comment>输出关系数据（子实体）</#comment>
        <#if de.getMajorPSDERs()??>
            <#list de.getMajorPSDERs() as der>
                <#if der.getDERType() =='DER1N' >
                    <#assign listcode=(der.getMinorCodeName()!der.getMinorPSDataEntity().getCodeName())>
                    <#if listcode?? && listcode==''><#assign listcode=der.getMinorPSDataEntity().getCodeName()></#if>
                    <#assign subDTOs = srfpluralize(listcode)?lower_case >
                    <#assign nested=der.isNestedRS()>
                    <#if nested == false && der.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                        <#list der.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                            <#if api.isNested()>
                                <#assign nested=true>
                            </#if>
                        </#list>
                    </#if>
                    <#if nested>
    /**
     * ${der.getMinorPSDataEntity().getLogicName()}
     */
    <#if der.getMinorPSDataEntity().getStorageMode()==0>
    @JSONField(name = "${subDTOs}")
    @JsonProperty("${subDTOs}")
    <#if der.getPSOne2ManyDataDEField()??>
    @Field(name = "${der.getPSOne2ManyDataDEField().getName()?lower_case}"）
    <#else >
    @Field(name = "${srfcaseformat(listcode,'l_u2lC')}")
    </#if>
    <#else >
    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    </#if>
    private List<${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.domain.${der.getMinorPSDataEntity().getCodeName()}> ${srfcaseformat(listcode,'l_u2lC')};

                    </#if>
                </#if>
            </#list>
        </#if>
    </#if>

    <#comment>联合主键</#comment>
    <#if item.getUnionKeyValuePSDEFields()??>
        <#assign keyField = item.getKeyPSDEField()>
        <#assign privateCodeName = srfcaseformat(keyField.getCodeName(),'l_u2lC') >
        <#assign publicCodeName = privateCodeName?cap_first >
    /**
     * 获取 [${keyField.getLogicName()}]
     */
    public ${srfjavatype(keyField.getStdDataType())} get${publicCodeName}(){
        if(ObjectUtils.isEmpty(${privateCodeName})){
            ${privateCodeName}=(${srfjavatype(keyField.stdDataType)})getDefaultKey(true);
        }
        return ${privateCodeName};
    }

    @Override
    public Serializable getDefaultKey(boolean gen) {
        ${checkUnionKey(item.getUnionKeyValuePSDEFields())}
            return DigestUtils.md5DigestAsHex(${getUnionKey(item.getUnionKeyValuePSDEFields())}.getBytes());
        return null;
    }
    </#if>

}

<#comment>Api存储</#comment>
<#elseif de.getStorageMode()==4 || de.getStorageMode()==0>
import ${pub.getPKGCodeName()}.util.domain.EntityClient;

/**
 * ServiceApi [${item.getLogicName()}] 对象
 */
@Data
public class ${item.getCodeName()} extends EntityClient implements Serializable {

    <#if de.getPSDEFields()??>
        <#comment>输出实体属性</#comment>
        <#list de.getPSDEFields() as defield>
        <#assign defDataType = (defield.getDataType())!"">
        <#if defDataType!='ONE2MANYDATA'>
        <#assign columnname = defield.getName()?lower_case>
        <#assign prvateCodeName = srfcaseformat(defield.getCodeName(),'l_u2lC') >
        <#assign publicCodeName = prvateCodeName?cap_first >
        <#assign jsonfield = defield.getCodeName()?lower_case >
        <#if de.getStorageMode()==0><#assign jsonfield = defield.getCodeName()?uncap_first ></#if>
        <#assign defieldano = "" >
        <#if prvateCodeName?lower_case != columnname>
            <#assign defieldano = "name = \""+columnname+"\"">
        </#if>
        <#if defield.getDefaultValue()?? && defield.getDefaultValue()!=''>
            <#assign defieldano = "defaultValue = \""+defield.getDefaultValue()+"\"">
        </#if>
        <#if defield.getDefaultValueType()?? && defield.getDefaultValueType()!=''>
            <#if defieldano?? && defieldano!=''>
                <#assign defieldano = defieldano+" , ">
            </#if>
            <#assign defieldano = defieldano+"defaultValueType = DEFieldDefaultValueType."+defield.getDefaultValueType()?upper_case>
        </#if>
        <#if defield.isKeyDEField()==true>
            <#if defieldano?? && defieldano!=''>
                <#assign defieldano = defieldano+" , ">
            </#if>
            <#assign defieldano = defieldano+"isKeyField=true">
        <#elseif defield.getPredefinedType()?? && defield.getPredefinedType()!=''>
            <#if defieldano?? && defieldano!=''>
                <#assign defieldano = defieldano+" , ">
            </#if>
            <#assign defieldano = defieldano+"preType = DEPredefinedFieldType."+defield.getPredefinedType()?upper_case>
            <#if defield.getPredefinedType()?lower_case =='logicvalid'>
                <#if de.getLogicValidPSDEField()?? && de.isLogicValid()==true>
                    <#assign defieldano = defieldano+", logicval = \""+((item.getValidLogicValue())!'1')+"\" , logicdelval=\""+((item.getInvalidLogicValue())!'0')+"\"">
                </#if>
            </#if>
        </#if>
    /**
     * ${defield.getLogicName()}
     */
            <#comment>属性默认值</#comment>
            <#if defieldano?? && defieldano!='' && defield.isPhisicalDEField()==true>
    @DEField(${defieldano})
            </#if>
            <#assign defDataType = (defield.getDataType())!"">
            <#if defDataType == "DATETIME" || (defDataType=='PICKUPDATA' && srfdatatype(defield.getStdDataType())== "DATETIME" && defield.getValueFormat()=="%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "${jsonfield}" , format="yyyy-MM-dd HH:mm:ss")
            <#elseif defDataType == "DATE" || (defDataType=='PICKUPDATA' && srfdatatype(defield.getStdDataType())== "DATETIME" && defield.getValueFormat()=="%1$tY-%1$tm-%1$td")>
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "${jsonfield}" , format="yyyy-MM-dd")
            <#elseif defDataType == "TIME" || (defDataType=='PICKUPDATA' && srfdatatype(defield.getStdDataType())== "DATETIME" && defield.getValueFormat()=="%1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="HH:mm", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "${jsonfield}" , format="HH:mm")
            <#else>
    @JSONField(name = "${jsonfield}")
            </#if>
    @JsonProperty("${jsonfield}")
    private ${srfjavatype(defield.getStdDataType())} ${prvateCodeName};

        </#if>
        </#list>

        <#comment>创建1：N关系实体-输出主实体</#comment>
        <#if item.getMinorPSDERs?? && item.getMinorPSDERs()??>
            <#list item.getMinorPSDERs() as MinorPSDER>
                <#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
                    <#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()?? && MinorPSDER.getCodeName?? && MinorPSDER.getCodeName()??>
                        <#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
                        <#if MajorEntity.getCodeName?? && MinorPSDER.getCodeName()?? >
    /**
     * ${MinorPSDER.getLogicName()}
     */
    @JSONField(name = "${srfcaseformat(MinorPSDER.getCodeName(),'l_u2lC')?lower_case}")
    @JsonProperty("${srfcaseformat(MinorPSDER.getCodeName(),'l_u2lC')?lower_case}")
    private ${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().getCodeName()?lower_case}.domain.${MajorEntity.getCodeName()} ${srfcaseformat(MinorPSDER.getCodeName(),'l_u2lC')};

                        </#if>
                    </#if>
                </#if>
            </#list>
        </#if>

        <#comment>输出关系数据（子实体）</#comment>
        <#if de.getMajorPSDERs()??>
            <#list de.getMajorPSDERs() as der>
                <#if der.getDERType() =='DER1N' >
                    <#assign listcode=(der.getMinorCodeName()!der.getMinorPSDataEntity().getCodeName())>
                    <#if listcode?? && listcode==''><#assign listcode=der.getMinorPSDataEntity().getCodeName()></#if>
                    <#assign subDTOs = srfpluralize(listcode)?lower_case >
                    <#assign nested=der.isNestedRS()>
                    <#if nested == false && der.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                        <#list der.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                            <#if api.isNested()>
                                <#assign nested=true>
                            </#if>
                        </#list>
                    </#if>
                    <#if nested>
    /**
     * ${der.getMinorPSDataEntity().getLogicName()}
     */
    @JSONField(name = "${subDTOs}")
    @JsonProperty("${subDTOs}")
    private List<${pub.getPKGCodeName()}.core.${der.getMinorPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.domain.${der.getMinorPSDataEntity().getCodeName()}> ${srfcaseformat(listcode,'l_u2lC')};

                    </#if>
                </#if>
            </#list>
        </#if>


                <#comment>输出set方法用于设置null值</#comment>
        <#list de.getPSDEFields() as defield>
            <#assign defDataType = (defield.getDataType())!"">
            <#assign columnname = defield.getName()?lower_case>
            <#assign prvateCodeName = srfcaseformat(defield.getCodeName(),'l_u2lC') >
            <#assign publicCodeName = prvateCodeName?cap_first >
            <#assign jsonfield = defield.getCodeName()?lower_case >
            <#if defield.isPhisicalDEField()==true && defield.isKeyDEField()==false && defDataType!='ONE2MANYDATA'>
            <#if defield.getPredefinedType()?? && defield.getPredefinedType()!=''>
                <#else >
    /**
     * 设置 [${defield.getLogicName()}]
     */
    public void set${publicCodeName}(${srfjavatype(defield.getStdDataType())} ${prvateCodeName}){
        this.${prvateCodeName} = ${prvateCodeName} ;
        this.modify("${columnname}",${prvateCodeName});
    }
                </#if>
            </#if>
        </#list>

    </#if>
}

</#if>

<#comment>获取联合主键：返回值 String.format("%s||%s",this.getHumanid(),this.getHumanname() </#comment>
<#function getUnionKey unionKeyList>
    <#assign formatKey="">
    <#assign formatValue="">
    <#list item.getUnionKeyValuePSDEFields() as defield>
        <#assign unionKeyPrivateCodeName = srfcaseformat(defield.getCodeName(),'l_u2lC') >
        <#assign unionKeyPublicCodeName = unionKeyPrivateCodeName?cap_first >
        <#assign formatKey=formatKey+"%s">
        <#if defield_has_next>
            <#assign formatKey=formatKey+"||">
        </#if>
        <#assign formatValue=formatValue+"this.get"+unionKeyPublicCodeName+"()">
        <#if defield_has_next>
            <#assign formatValue=formatValue+",">
        </#if>
    </#list>
    <#assign unionKeyResult="String.format(\""+formatKey+"\" ,"+formatValue+")">
    <#return unionKeyResult>
</#function>

<#function checkUnionKey unionKeyList>
    <#assign formatValue="">
    <#list item.getUnionKeyValuePSDEFields() as defield>
        <#assign unionKeyPrivateCodeName = srfcaseformat(defield.getCodeName(),'l_u2lC') >
        <#assign unionKeyPublicCodeName = unionKeyPrivateCodeName?cap_first >
        <#assign formatValue=formatValue+"(!ObjectUtils.isEmpty(this.get"+unionKeyPublicCodeName+"()))">
        <#if defield_has_next>
            <#assign formatValue=formatValue+"&&">
        </#if>
    </#list>
    <#assign unionKeyResult="if("+formatValue+")">
    <#return unionKeyResult>
</#function>






